import mongoose, { Schema, Document } from 'mongoose';
import { Participant, ParticipantType } from '../types';

export interface ParticipantDocument extends Omit<Participant, 'id'>, Document {
  id: number;
}

const participantSchema = new Schema<ParticipantDocument>(
  {
    id: { type: Number, required: true, unique: true },
    participantType: {
      type: String,
      required: true,
      enum: ['TEAM', 'DRIVER', 'PLAYER'] as ParticipantType[]
    },
    sportId: { type: Number, required: true },
    sportName: { type: String, required: true },
    leagueIds: [{ type: Number }],
    leagueNames: [{ type: String }],
    teamName: { type: String, default: null },
    fullName: { type: String, default: null },
    shortName: { type: String, default: null },
    abbreviation: { type: String, default: null },
    teamLogo: { type: String, default: null },
    isActive: { type: Boolean, default: true },
  },
  {
    timestamps: true,
    toJSON: {
      transform: (_doc, ret: Record<string, unknown>) => {
        delete ret._id;
        delete ret.__v;
        return ret;
      },
    },
  }
);

// Indexes
participantSchema.index({ sportId: 1, participantType: 1, isActive: 1 });
participantSchema.index({ leagueIds: 1 });
participantSchema.index({ teamName: 1 });

export const ParticipantModel = mongoose.model<ParticipantDocument>('Participant', participantSchema);
