import { SportsService } from './sports.service';

// Force JSON store mode for tests
process.env.USE_JSON_STORE = 'true';

describe('SportsService', () => {
  let service: SportsService;

  beforeAll(() => {
    service = new SportsService();
  });

  describe('getAllSports', () => {
    it('should return all sports', async () => {
      const sports = await service.getAllSports();

      expect(Array.isArray(sports)).toBe(true);
      expect(sports.length).toBeGreaterThan(0);
    });

    it('should return sports sorted by name', async () => {
      const sports = await service.getAllSports();

      const names = sports.map(s => s.sportName);
      const sorted = [...names].sort();
      expect(names).toEqual(sorted);
    });

    it('should filter by isActive=true', async () => {
      const sports = await service.getAllSports(true);

      expect(sports.every(s => s.isActive === true)).toBe(true);
    });

    it('should filter by isActive=false', async () => {
      const sports = await service.getAllSports(false);

      expect(sports.every(s => s.isActive === false)).toBe(true);
    });

    it('should return sports with correct structure', async () => {
      const sports = await service.getAllSports();

      if (sports.length > 0) {
        const sport = sports[0];
        expect(sport).toHaveProperty('id');
        expect(sport).toHaveProperty('sportName');
        expect(sport).toHaveProperty('icon');
        expect(sport).toHaveProperty('isActive');
      }
    });
  });

  describe('getSportById', () => {
    it('should return a sport by ID', async () => {
      const sports = await service.getAllSports();
      if (sports.length > 0) {
        const sport = await service.getSportById(sports[0].id);

        expect(sport).not.toBeNull();
        expect(sport?.id).toBe(sports[0].id);
      }
    });

    it('should return null for non-existent ID', async () => {
      const sport = await service.getSportById(99999);

      expect(sport).toBeNull();
    });
  });
});
