import mongoose, { Schema, Document } from 'mongoose';
import { League } from '../types';

export interface LeagueDocument extends Omit<League, 'id'>, Document {
  id: number;
}

const leagueSchema = new Schema<LeagueDocument>(
  {
    id: { type: Number, required: true, unique: true },
    sportId: { type: Number, required: true },
    sportName: { type: String, required: true },
    leagueName: { type: String, required: true },
    leagueLogo: { type: String, default: null },
    isActive: { type: Boolean, default: true },
  },
  {
    timestamps: true,
    toJSON: {
      transform: (_doc, ret: Record<string, unknown>) => {
        delete ret._id;
        delete ret.__v;
        return ret;
      },
    },
  }
);

// Indexes
leagueSchema.index({ sportId: 1, isActive: 1 });
leagueSchema.index({ leagueName: 1 });
leagueSchema.index({ sportName: 1 });

export const LeagueModel = mongoose.model<LeagueDocument>('League', leagueSchema);
