import mongoose, { Schema, Document } from 'mongoose';
import { Template } from '../types';

export interface TemplateDocument extends Omit<Template, 'id'>, Document {
  id: number;
}

const templateSchema = new Schema<TemplateDocument>(
  {
    id: { type: Number, required: true, unique: true },
    sportId: { type: Number, required: true },
    sportName: { type: String, required: true },
    leagueId: { type: Number, default: null },
    leagueName: { type: String, default: null },
    participantId: { type: Number, default: null },
    teamName: { type: String, default: null },
    widgetTypeId: { type: Number, required: true },
    widgetName: { type: String, required: true },
    templateName: { type: String, required: true },
    darkThemeUrl: { type: String, required: true },
    lightThemeUrl: { type: String, required: true },
    thumbnailDark: { type: String, default: null },
    thumbnailLight: { type: String, default: null },
    featured: { type: Boolean, default: false },
    isActive: { type: Boolean, default: true },
  },
  {
    timestamps: true,
    toJSON: {
      transform: (_doc, ret: Record<string, unknown>) => {
        delete ret._id;
        delete ret.__v;
        return ret;
      },
    },
  }
);

// Indexes
templateSchema.index({ sportId: 1, widgetTypeId: 1, isActive: 1 });
templateSchema.index({ leagueId: 1, isActive: 1 });
templateSchema.index({ participantId: 1 });
templateSchema.index({ featured: 1, isActive: 1 });

export const TemplateModel = mongoose.model<TemplateDocument>('Template', templateSchema);
