import mongoose, { Schema, Document } from 'mongoose';
import { WidgetType } from '../types';

export interface WidgetTypeDocument extends Omit<WidgetType, 'id'>, Document {
  id: number;
}

const widgetTypeSchema = new Schema<WidgetTypeDocument>(
  {
    id: { type: Number, required: true, unique: true },
    sportId: { type: Number, required: true },
    sportName: { type: String, required: true },
    leagueId: { type: Number, default: null },
    leagueName: { type: String, default: null },
    widgetName: { type: String, required: true },
    isActive: { type: Boolean, default: true },
  },
  {
    timestamps: true,
    toJSON: {
      transform: (_doc, ret: Record<string, unknown>) => {
        delete ret._id;
        delete ret.__v;
        return ret;
      },
    },
  }
);

// Indexes
widgetTypeSchema.index({ sportId: 1, isActive: 1 });
widgetTypeSchema.index({ leagueId: 1, isActive: 1 });
widgetTypeSchema.index({ widgetName: 1 });

export const WidgetTypeModel = mongoose.model<WidgetTypeDocument>('WidgetType', widgetTypeSchema);
