import { Router } from 'express';
import { apiKeyAuth } from '../middleware/auth.middleware';
import sportsRouter from './sports.routes';
import leaguesRouter from './leagues.routes';
import templatesRouter from './templates.routes';

const router = Router();

// Apply API key authentication to all routes
router.use(apiKeyAuth);

// Mount routes
router.use('/sports', sportsRouter);
router.use('/leagues', leaguesRouter);
router.use('/templates', templatesRouter);

export default router;
