import { Router } from 'express';
import { participantsController } from '../controllers/participants.controller';
import { widgetTypesController } from '../controllers/widget-types.controller';

const router = Router();

// GET /leagues/:leagueId/participants - Get participants for a league
router.get('/:leagueId/participants', (req, res, next) => participantsController.getParticipantsByLeague(req, res, next));

// GET /leagues/:leagueId/widget-types - Get widget types for a league
router.get('/:leagueId/widget-types', (req, res, next) => widgetTypesController.getWidgetTypesByLeague(req, res, next));

export default router;
