import { Sport, League, Participant, WidgetType, Template, TemplateWithEmbed } from '../types';

/**
 * Formats response objects with logically ordered keys.
 * Groups related fields together (e.g., sportId + sportName, leagueId + leagueName)
 */

export function formatSport(sport: Sport): Sport {
  return {
    id: sport.id,
    sportName: sport.sportName,
    icon: sport.icon,
    isActive: sport.isActive,
    createdAt: sport.createdAt,
    updatedAt: sport.updatedAt,
  };
}

export function formatLeague(league: League): League {
  return {
    id: league.id,
    sportId: league.sportId,
    sportName: league.sportName,
    leagueName: league.leagueName,
    leagueLogo: league.leagueLogo,
    isActive: league.isActive,
    createdAt: league.createdAt,
    updatedAt: league.updatedAt,
  };
}

export function formatParticipant(participant: Participant): Participant {
  return {
    id: participant.id,
    participantType: participant.participantType,
    sportId: participant.sportId,
    sportName: participant.sportName,
    leagueIds: participant.leagueIds,
    leagueNames: participant.leagueNames,
    teamName: participant.teamName,
    fullName: participant.fullName,
    shortName: participant.shortName,
    abbreviation: participant.abbreviation,
    teamLogo: participant.teamLogo,
    isActive: participant.isActive,
    createdAt: participant.createdAt,
    updatedAt: participant.updatedAt,
  };
}

export function formatWidgetType(widgetType: WidgetType): WidgetType {
  return {
    id: widgetType.id,
    sportId: widgetType.sportId,
    sportName: widgetType.sportName,
    leagueId: widgetType.leagueId,
    leagueName: widgetType.leagueName,
    widgetName: widgetType.widgetName,
    isActive: widgetType.isActive,
    createdAt: widgetType.createdAt,
    updatedAt: widgetType.updatedAt,
  };
}

export function formatTemplate(template: Template): Template {
  return {
    id: template.id,
    sportId: template.sportId,
    sportName: template.sportName,
    leagueId: template.leagueId,
    leagueName: template.leagueName,
    participantId: template.participantId,
    teamName: template.teamName,
    widgetTypeId: template.widgetTypeId,
    widgetName: template.widgetName,
    templateName: template.templateName,
    darkThemeUrl: template.darkThemeUrl,
    lightThemeUrl: template.lightThemeUrl,
    thumbnailDark: template.thumbnailDark,
    thumbnailLight: template.thumbnailLight,
    featured: template.featured,
    isActive: template.isActive,
    createdAt: template.createdAt,
    updatedAt: template.updatedAt,
  };
}

export function formatTemplateWithEmbed(template: TemplateWithEmbed): TemplateWithEmbed {
  return {
    id: template.id,
    sportId: template.sportId,
    sportName: template.sportName,
    leagueId: template.leagueId,
    leagueName: template.leagueName,
    participantId: template.participantId,
    teamName: template.teamName,
    widgetTypeId: template.widgetTypeId,
    widgetName: template.widgetName,
    templateName: template.templateName,
    darkThemeUrl: template.darkThemeUrl,
    lightThemeUrl: template.lightThemeUrl,
    thumbnailDark: template.thumbnailDark,
    thumbnailLight: template.thumbnailLight,
    featured: template.featured,
    isActive: template.isActive,
    embedCodeDark: template.embedCodeDark,
    embedCodeLight: template.embedCodeLight,
    createdAt: template.createdAt,
    updatedAt: template.updatedAt,
  };
}
