# SportPulse Widget API Documentation

## Interactive Documentation

For full interactive API documentation with examples, visit:

**http://localhost:3001/docs**

The interactive documentation is powered by [ReDoc](https://github.com/Redocly/redoc) and provides:
- Complete endpoint descriptions
- Request/response schemas
- Example payloads
- Try-it-out functionality

## Quick Reference

### Base URL

```
http://localhost:3001/api/v1
```

### Authentication

All endpoints require an API key in the `X-API-Key` header:

```bash
curl -H "X-API-Key: your-api-key" http://localhost:3001/api/v1/sports
```

**Development API Key:** `test-api-key-for-development`

---

## Endpoints Summary

| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/sports` | List all sports |
| GET | `/sports/{sportId}/leagues` | Get leagues for a sport |
| GET | `/leagues/{leagueId}/participants` | Get participants for a league |
| GET | `/leagues/{leagueId}/widget-types` | Get widget types for a league |
| GET | `/templates` | Get templates with embed codes |

---

## Quick Examples

### Get All Sports

```bash
curl -H "X-API-Key: test-api-key-for-development" \
  http://localhost:3001/api/v1/sports
```

### Get NBA Leagues (Basketball = sportId 3)

```bash
curl -H "X-API-Key: test-api-key-for-development" \
  http://localhost:3001/api/v1/sports/3/leagues
```

### Get Widget Types for NBA (leagueId 7)

```bash
curl -H "X-API-Key: test-api-key-for-development" \
  http://localhost:3001/api/v1/leagues/7/widget-types
```

### Get Templates with Embed Codes

```bash
curl -H "X-API-Key: test-api-key-for-development" \
  "http://localhost:3001/api/v1/templates?sportId=3&leagueId=7"
```

---

## Response Schema

### Sport

| Field | Type | Description |
|-------|------|-------------|
| id | integer | Unique identifier |
| sportName | string | Sport name (slug format) |
| icon | string \| null | Sport icon URL |
| isActive | boolean | Active status |

### League

| Field | Type | Description |
|-------|------|-------------|
| id | integer | Unique identifier |
| sportId | integer | Parent sport ID |
| sportName | string | Parent sport name |
| leagueName | string | League name (slug format) |
| leagueLogo | string \| null | League logo URL |
| isActive | boolean | Active status |

### Widget Type

| Field | Type | Description |
|-------|------|-------------|
| id | integer | Unique identifier |
| sportId | integer | Associated sport ID |
| sportName | string | Associated sport name |
| leagueId | integer \| null | Associated league ID |
| leagueName | string \| null | Associated league name |
| widgetName | string | Widget name (slug format) |
| isActive | boolean | Active status |

### Template

| Field | Type | Description |
|-------|------|-------------|
| id | integer | Unique identifier |
| sportId | integer | Associated sport ID |
| sportName | string | Associated sport name |
| leagueId | integer \| null | Associated league ID |
| leagueName | string \| null | Associated league name |
| participantId | integer \| null | Associated participant ID |
| teamName | string \| null | Associated team name |
| widgetTypeId | integer | Widget type ID |
| widgetName | string | Widget name |
| templateName | string | Template display name |
| darkThemeUrl | string \| null | Dark theme widget URL (null if not available) |
| lightThemeUrl | string \| null | Light theme widget URL (null if not available) |
| thumbnailDark | string \| null | Dark theme thumbnail |
| thumbnailLight | string \| null | Light theme thumbnail |
| featured | boolean | Featured flag |
| isActive | boolean | Active status |
| embedCodeDark | string \| null | Ready-to-use dark theme iframe (null if darkThemeUrl is null) |
| embedCodeLight | string \| null | Ready-to-use light theme iframe (null if lightThemeUrl is null) |

---

## Data Reference

### Sports

| ID | Name |
|----|------|
| 1 | american-football |
| 2 | baseball |
| 3 | basketball |
| 4 | hockey |
| 5 | motorsport |
| 6 | soccer |

### Leagues

| Sport | League ID | League Name |
|-------|-----------|-------------|
| american-football | 8 | ncaa-fbs |
| american-football | 10 | nfl |
| baseball | 6 | mlb |
| basketball | 7 | nba |
| basketball | 9 | ncaab-di |
| hockey | 11 | nhl |
| motorsport | 12 | f1 |
| motorsport | 14 | nascar |
| soccer | 1 | bundesliga |
| soccer | 2 | laliga |
| soccer | 3 | ligue-1 |
| soccer | 4 | mls |
| soccer | 5 | premier-league |
| soccer | 13 | serie-a |

---

## OpenAPI Specification

The full OpenAPI 3.0 specification is available at:

- **JSON:** http://localhost:3001/openapi.json
- **YAML:** http://localhost:3001/openapi.yaml

---

## Error Codes

| HTTP Status | Code | Description |
|-------------|------|-------------|
| 401 | MISSING_API_KEY | No API key provided |
| 401 | INVALID_API_KEY | Invalid or expired API key |
| 404 | SPORT_NOT_FOUND | Sport ID not found |
| 404 | LEAGUE_NOT_FOUND | League ID not found |
