import { Request, Response, NextFunction } from 'express';
import { participantsService } from '../services';
import { leaguesService } from '../services';
import { participantsQuerySchema, leagueIdParamSchema } from '../validation/schemas';
import { ApiError } from '../middleware/error.middleware';

export class ParticipantsController {
  async getParticipantsByLeague(req: Request, res: Response, next: NextFunction): Promise<void> {
    try {
      const { leagueId } = leagueIdParamSchema.parse(req.params);
      const query = participantsQuerySchema.parse(req.query);

      // Verify league exists
      const league = await leaguesService.getLeagueById(leagueId);
      if (!league) {
        throw new ApiError(404, 'League not found', 'LEAGUE_NOT_FOUND');
      }

      const participants = await participantsService.getParticipantsByLeagueId(
        leagueId,
        query.type,
        query.isActive
      );
      res.json({ participants });
    } catch (error) {
      next(error);
    }
  }
}

export const participantsController = new ParticipantsController();
