import app from './app';
import { config } from './config/env';
import { connectDatabase } from './config/database';

async function main() {
  if (config.useJsonStore) {
    console.log('Using JSON file as data store (no MongoDB required)');
  } else {
    await connectDatabase();
  }

  app.listen(config.port, () => {
    console.log(`SportPulse Widget API running on port ${config.port}`);
    console.log(`Environment: ${config.nodeEnv}`);
    console.log(`Data store: ${config.useJsonStore ? 'JSON file' : 'MongoDB'}`);
  });
}

main().catch((error) => {
  console.error('Failed to start server:', error);
  process.exit(1);
});
