import { Router } from 'express';
import { sportsController } from '../controllers/sports.controller';
import { leaguesController } from '../controllers/leagues.controller';

const router = Router();

// GET /sports - List all sports
router.get('/', (req, res, next) => sportsController.getSports(req, res, next));

// GET /sports/:sportId/leagues - Get leagues for a sport
router.get('/:sportId/leagues', (req, res, next) => leaguesController.getLeaguesBySport(req, res, next));

export default router;
